%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %
    % Ask user to choose the instrument
    %
    % Default parameters to  instrument = 'S2VNA
    
    
clear
close all

instrchoice = menu('Please choose your instrument','S5048','S7530','Planar804','Planar304','S8081 (Planar808/1)','R54','R140','TR1300','TR5048','TR7530');


switch instrchoice
    case 1
        instrument = 'S2VNA'; % S5048
    case 2
        instrument = 'S2VNA'; % S7530
    case 3
        instrument = 'S2VNA'; % Planar804
    case 4
        instrument = 'S2VNA'; % Planar304
    case 5
        instrument = 'S4VNA'; % S8081
    case 6
        instrument = 'RVNA';  % R54
    case 7
        instrument = 'RVNA';  % R140
    case 8
        instrument = 'TRVNA'; % TR1300
    case 9
        instrument = 'TRVNA'; % TR5048
    case 10
        instrument = 'TRVNA'; % TR7530
    otherwise
        instrument = 'S2VNA'; % Planar804
end

% ask user to choose user span type.

freqtype = menu('use_center_and_span','Start and stop frequency','Center and span frequency');
if(freqtype == 1)
    use_center_and_span = false;
else
    use_center_and_span = true;
end

%prompt for freq, num of points and power level
temp1 = inputdlg({'Enter the start/center frequency (MHz)','Enter the stop/center frequency (MHz)','Enter the number of points','Enter Power level (dbm)'},'Input',4,{'300','6000','201','0'});
f1_hz = temp1{1};
f2_hz = temp1{2};
num_points = temp1{3};
power_level_dbm = temp1{4};

% prompt for measurement parameter
% default to S11
parchoice = menu('Please choose the parameter','S11','S21','S22','S12','A','B','R1','R2');

switch parchoice
    case 1
        parameter = 'S11';
    case 2
        parameter = 'S21';
    case 3
        parameter = 'S22';
    case 4
        parameter = 'S12';
    case 5
        parameter = 'A';
    case 6
        parameter = 'B';
    case 7
        parameter = 'R1';
    case 8
        parameter = 'R2';
    otherwise
        parameter = 'S11';
end

% prompt for format
% default to Log magnitude
formatchoice = menu('Please format type','Logarithmic magnitude','Phase','Smith chart format (R + jX)','Group delay time','Polar format (Real/Imag)');

switch formatchoice
    case 1
        format = 'MLOGarithmic';
    case 2
        format = 'PHASe';
    case 3
        format = 'SMITh';
    case 4
        format = 'GDELay';
    case 5
        format = 'POLar';
    otherwise
        format = 'MLOGarithmic';
end


%prompt for time per iteration, number of iteration and number of iteration to store
temp2 = inputdlg({'Enter time per iteration (sec)','Enter number of iteration','Enter number of iteration to store'},'Input',3,{'1','10','0'});
time_per_iter_sec = str2num(temp2{1});
num_iter = str2num(temp2{2});
num_iter_to_store = str2num(temp2{3});

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  Example code
%

nl = 10; %ASCII code for new line

%Instantiate TCP server
try
    vna = tcpclient('127.0.0.1', 5025, 'Timeout',1);
catch ME
    disp('Error establishing TCP connection.');
    disp('Check that the TCP server is on.');
    return
end

%Clear the instrument
write(vna, [uint8('*CLS'), nl]);
pause(0.1);

%Get and echo the instrument name, serial number, etc.
%
%  [This is a simple example of getting a property in MATLAB.]
%
write(vna, [uint8('*IDN?'), nl]);
pause(0.1);
disp(char(read(vna)));
pause(0.1);

%Set the instrument to a Preset state
%
%  [This is an example of executing a SCPI command in MATLAB.]
%
write(vna, [uint8('SYSTem:PRESet'), nl]);
pause(0.1);

%Configure the stimulus
if use_center_and_span
    write(vna, [uint8(['SENSe1:FREQuency:CENTer ', f1_hz, 'MHz']), nl]);
    pause(0.1);
    write(vna, [uint8(['SENSe1:FREQuency:SPAN ', f2_hz, 'MHz']), nl]);
    pause(0.1);
else
    write(vna, [uint8(['SENSe1:FREQuency:STARt ', f1_hz, 'MHz']), nl]);
    pause(0.1);
    write(vna, [uint8(['SENSe1:FREQuency:STOP ', f2_hz, 'MHz']), nl]);
    pause(0.1);
end


write(vna, [uint8(['SENSe1:SWEep:POInts ', num_points]), nl]);
pause(0.1);

if(instrument(1) ~= 'R')
    write(vna, [uint8(['SOURce1:POWer:LEVel:IMMediate ', power_level_dbm]), nl]);
    pause(0.1);
end

%Configure the measurement type
pause(0.1);
write(vna, [uint8(['CALCulate1:PARameter:DEFine ', parameter]), nl]);
pause(0.1);
write(vna, [uint8(['CALCulate1:SELected:FORMat ', format]), nl]);
pause(0.1);
write(vna, [uint8('TRIGger:SEQuence:SOURce BUS'), nl]);
pause(0.1);

tic;

for iter = 1:num_iter

  %Execute the measurement
   write(vna, [uint8('*WAI'), nl]);
   pause(0.01);
   write(vna, [uint8('TRIGger:SEQuence:SINGle'), nl]);
   pause(0.01);
   

   while(toc<iter*time_per_iter_sec)
       pause(0.1);
   end
   
   
   write(vna, [uint8('CALCulate:DATA:FDATa?'), nl]);
   pause(0.01);
   Y = read(vna);
   pause(0.01);
   Y = char(Y);
   Y = str2num(Y);
   Y = Y(1:2:end);
   
   pause(0.01);
   write(vna, [uint8('SENSe1:FREQuency:DATA?'), nl]);
   write(vna, nl);
   pause(0.01);
   F = read(vna);
   pause(0.01);
   F = char(F);
   F = str2num(F);
    
   try
        figure(1);
        plot(F,Y);
   catch ME
       disp('Error with getting the data.');
       disp('Try setting a longer iteration time.');
       break;
   end
       

   if iter<=num_iter_to_store
       fprintf(vna, ['MMEMory:STORe:IMAGe ','c:\vna\trvna\image\', num2str(iter), '.png']);
       pause(0.01);
       fprintf(vna, ['MMEMory:STORe:FDATa ','c:\vna\trvna\csv\', num2str(iter), '.csv']);
       pause(0.01);
   end
   

end

